#! /usr/local/bin/R
#
# reg_event_study.R
#
#
# 
#
#
# Created on     January  05th 2020
# Last modified  February 12th 2020
#
#
# ------------------------------------------------------------------------------------------

# ------------------------------------------------------------------------------------------
message("Log file for code executed at\n")
message(format(Sys.time(), "%a %b %d %X %Y"))
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
library(crayon)
library(devtools)

suppressMessages(suppressWarnings(library(bit64,verbose=F,  warn.conflicts = F, quietly = T)));
library(lfe,  warn.conflicts = F, quietly = T);
library(zeallot)
library(stargazer,  warn.conflicts = F, quietly = T);
library(texreg,  warn.conflicts = F, quietly = T);
library(brew)
library(purrr)
library(magrittr,  warn.conflicts = F, quietly = T);
library(stringr,  warn.conflicts = F, quietly = T);
library(glue,  warn.conflicts = F, quietly = T)
library(haven,  warn.conflicts = F, quietly = T)
library(data.table,  warn.conflicts = F, quietly = T);
library(statar,  warn.conflicts = F, quietly = T)
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# APPEND REQUIRED PACKAGES
check_file = file.exists("log/R-session-info.log.R")
sink("log/R-session-info.log.R", append=check_file)
cat(bold("\n\n# -----\n# Session info for event_cumecu.R\n\n")) 
session_info()
sink()
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# LOAD THE DATA
dt_event_daily <- readRDS("./output/trade_fxdaily_reg_data.rds")
# ------------------------------------------------------------------------------------------

# ------------------------------------------------------------------------------------------
# KEEPING ONLY BILATERAL DEALS
dt_event_daily[ , bil_OWPTA := sum(deal_change_OWPTA_un, na.rm = T), by = ISOPAIR]
dt_event_daily[ , bil_TWPTA := sum(deal_change_TWPTA_un, na.rm = T), by = ISOPAIR]
dt_event_daily[ , bil_FTA := sum(deal_change_FTA_un, na.rm = T), by = ISOPAIR]
dt_event_daily[ , bil_CUCMECU := sum(deal_change_CUCMECU_un, na.rm = T), by = ISOPAIR]

## Updating EIA dummies with only bilateral deals:
  dt_event_daily[, OWPTA := fifelse(bil_OWPTA >= 1, OWPTA, 0) ]
  dt_event_daily[, TWPTA := fifelse(bil_TWPTA >= 1, TWPTA, 0) ]
  dt_event_daily[, FTA := fifelse(bil_FTA >= 1, FTA, 0) ]
  dt_event_daily[, CUMECU := fifelse(bil_CUCMECU >= 1, CUMECU, 0) ]
 
 # Identifying missing observations
  dt_event_daily[ is.na(EIA) | EIA == -999, CUMECU := NA ]
  dt_event_daily[ is.na(EIA) | EIA == -999, FTA    := NA ]
  dt_event_daily[ is.na(EIA) | EIA == -999, TWPTA  := NA ]
  dt_event_daily[ is.na(EIA) | EIA == -999, OWPTA  := NA ]
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
create_lagvar <- function(dt_in){
  
  # FX VOLATILITY IF WE DO ANNUAL
  dt_in[, d_fx_vol       := fx_vol_annual - tlag(fx_vol_annual, n=1L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d5_fx_vol      := fx_vol_annual - tlag(fx_vol_annual, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d10_fx_vol     := fx_vol_annual - tlag(fx_vol_annual, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, d15_fx_vol     := fx_vol_annual - tlag(fx_vol_annual, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, f_d_fx_vol     :=  tlead(fx_vol_annual, n=1L,  time=year) - fx_vol_annual, by = .(ISOPAIR) ]
  dt_in[, f2_d2_fx_vol   :=  tlead(fx_vol_annual, n=2L,  time=year) - fx_vol_annual, by = .(ISOPAIR) ]
  dt_in[, f5_d5_fx_vol   :=  tlead(fx_vol_annual, n=5L,  time=year) - fx_vol_annual, by = .(ISOPAIR) ]
  dt_in[, f10_d10_fx_vol :=  tlead(fx_vol_annual, n=10L, time=year) - fx_vol_annual, by = .(ISOPAIR) ]
  dt_in[, f15_d15_fx_vol :=  tlead(fx_vol_annual, n=15L, time=year) - fx_vol_annual, by = .(ISOPAIR) ]
  
  dt_in[, f10_d5_fx_vol  :=  tlead(fx_vol_annual, n=10L,  time=year) - tlead(fx_vol_annual, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, f15_d10_fx_vol :=  tlead(fx_vol_annual, n=15L,  time=year) - tlead(fx_vol_annual, n=5L,  time=year), by = .(ISOPAIR) ]
  
  # Adjusted Volatility
  dt_in[, d_vol_adj       := vol_adj - tlag(vol_adj, n=1L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d5_vol_adj      := vol_adj - tlag(vol_adj, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d10_vol_adj     := vol_adj - tlag(vol_adj, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, d15_vol_adj     := vol_adj - tlag(vol_adj, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, f_d_vol_adj     :=  tlead(vol_adj, n=1L,  time=year) - vol_adj, by = .(ISOPAIR) ]
  dt_in[, f2_d2_vol_adj   :=  tlead(vol_adj, n=2L,  time=year) - vol_adj, by = .(ISOPAIR) ]
  dt_in[, f5_d5_vol_adj   :=  tlead(vol_adj, n=5L,  time=year) - vol_adj, by = .(ISOPAIR) ]
  dt_in[, f10_d10_vol_adj :=  tlead(vol_adj, n=10L, time=year) - vol_adj, by = .(ISOPAIR) ]
  dt_in[, f15_d15_vol_adj :=  tlead(vol_adj, n=15L, time=year) - vol_adj, by = .(ISOPAIR) ]
  
  dt_in[, f10_d5_vol_adj  :=  tlead(vol_adj, n=10L,  time=year) - tlead(vol_adj, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, f15_d10_vol_adj :=  tlead(vol_adj, n=15L,  time=year) - tlead(vol_adj, n=5L,  time=year), by = .(ISOPAIR) ]
  
  # BETA OF FX REGRESSION
  dt_in[, d_beta       := beta - tlag(beta, n=1L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d5_beta      := beta - tlag(beta, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d10_beta     := beta - tlag(beta, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, d15_beta     := beta - tlag(beta, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, f_d_beta     :=  tlead(beta, n=1L,  time=year) - beta, by = .(ISOPAIR) ]
  dt_in[, f2_d2_beta   :=  tlead(beta, n=2L,  time=year) - beta, by = .(ISOPAIR) ]
  dt_in[, f5_d5_beta   :=  tlead(beta, n=5L,  time=year) - beta, by = .(ISOPAIR) ]
  dt_in[, f10_d10_beta :=  tlead(beta, n=10L, time=year) - beta, by = .(ISOPAIR) ]
  dt_in[, f15_d15_beta :=  tlead(beta, n=15L, time=year) - beta, by = .(ISOPAIR) ]
  
  dt_in[, f10_d5_beta  :=  tlead(beta, n=10L,  time=year) - tlead(beta, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, f15_d10_beta :=  tlead(beta, n=15L,  time=year) - tlead(beta, n=5L,  time=year), by = .(ISOPAIR) ]
  
  # R2 OF FX REGRESSION
  dt_in[, d_R2_y       := R2_y - tlag(R2_y, n=1L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d5_R2_y      := R2_y - tlag(R2_y, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d10_R2_y     := R2_y - tlag(R2_y, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, d15_R2_y     := R2_y - tlag(R2_y, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, f_d_R2_y     :=  tlead(R2_y, n=1L,  time=year) - R2_y, by = .(ISOPAIR) ]
  dt_in[, f2_d2_R2_y   :=  tlead(R2_y, n=2L,  time=year) - R2_y, by = .(ISOPAIR) ]
  dt_in[, f5_d5_R2_y   :=  tlead(R2_y, n=5L,  time=year) - R2_y, by = .(ISOPAIR) ]
  dt_in[, f10_d10_R2_y :=  tlead(R2_y, n=10L, time=year) - R2_y, by = .(ISOPAIR) ]
  dt_in[, f15_d15_R2_y :=  tlead(R2_y, n=15L, time=year) - R2_y, by = .(ISOPAIR) ]
  
  dt_in[, f10_d5_R2_y  :=  tlead(R2_y, n=10L,  time=year) - tlead(R2_y, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, f15_d10_R2_y :=  tlead(R2_y, n=15L,  time=year) - tlead(R2_y, n=5L,  time=year), by = .(ISOPAIR) ]
  
  # TRADE (or IMPORTS)
  dt_in[, trade         := log_import ]
  dt_in[, d_trade       := trade - tlag(trade, n=1L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d2_trade      := trade - tlag(trade, n=2L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d5_trade      := trade - tlag(trade, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, d10_trade     := trade - tlag(trade, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, d15_trade     := trade - tlag(trade, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, f_d_trade     :=  tlead(trade, n=1L,  time=year) - trade, by = .(ISOPAIR) ]
  dt_in[, f2_d2_trade   :=  tlead(trade, n=2L,  time=year) - trade, by = .(ISOPAIR) ]
  dt_in[, f5_d5_trade   :=  tlead(trade, n=5L,  time=year) - trade, by = .(ISOPAIR) ]
  dt_in[, f5_d10_trade   :=  tlead(d10_trade, n=5L,  time=year), by = .(ISOPAIR) ]
  dt_in[, f10_d10_trade :=  tlead(trade, n=10L, time=year) - trade, by = .(ISOPAIR) ]
  dt_in[, f15_d15_trade :=  tlead(trade, n=15L, time=year) - trade, by = .(ISOPAIR) ]
  dt_in[, l5_d5_trade   :=  tlag(trade, n=5L,  time=year) - tlag(trade, n=10L, time=year), by = .(ISOPAIR) ]
  dt_in[, l10_d5_trade  :=  tlag(trade, n=10L,  time=year) - tlag(trade, n=15L, time=year), by = .(ISOPAIR) ]
  dt_in[, l5_d10_trade  :=  tlag(trade, n=5L,  time=year) - tlag(trade, n=15L, time=year), by = .(ISOPAIR) ]
  
  # DEALS (Always in the past)
  dt_in[, d2_CUMECU := CUMECU - tlag(CUMECU, n=2L, time=year), by = .(ISOPAIR) ]
  dt_in[, d2_FTA    := FTA - tlag(FTA, n=2L, time=year), by = .(ISOPAIR) ]
  dt_in[, d2_TWPTA  := TWPTA - tlag(TWPTA, n=2L, time=year), by = .(ISOPAIR) ]
  dt_in[, d2_OWPTA  := OWPTA - tlag(OWPTA, n=2L, time=year), by = .(ISOPAIR) ]
  dt_in[, d2_PTA    := PTA - tlag(PTA, n=2L, time=year), by = .(ISOPAIR) ]
  dt_in[, d5_CUMECU := CUMECU - tlag(CUMECU, n=5L, time=year), by = .(ISOPAIR) ]
  dt_in[, d5_FTA    := FTA - tlag(FTA, n=5L, time=year), by = .(ISOPAIR) ]
  dt_in[, d5_TWPTA  := TWPTA - tlag(TWPTA, n=5L, time=year), by = .(ISOPAIR) ]
  dt_in[, d5_OWPTA  := OWPTA - tlag(OWPTA, n=5L, time=year), by = .(ISOPAIR) ]
  dt_in[, d5_PTA    := PTA - tlag(PTA, n=5L, time=year), by = .(ISOPAIR) ]
  
  return(dt_in)
}

dt_event_daily <- create_lagvar(dt_event_daily)
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# First Stage with trade in first difff
dt_reg <- dt_event_daily[ !is.na(ISOPAIR) & ISOPAIR != "" ]
dt_reg[, `:=`(ISO1 = base, ISO2 = foreign, datey = as.factor(year)) ]

dt_reg_tmp <- dt_reg[is.finite(f5_d5_trade) & is.finite(d5_trade) ]
r1  <- felm(f5_d5_trade ~ d5_CUMECU + d5_FTA + d5_TWPTA + d5_OWPTA + d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | 0 | ISOPAIR, dt_reg_tmp)
r2  <- felm(f5_d5_trade ~ d5_CUMECU + d5_FTA + d5_TWPTA + d5_OWPTA + d5_trade | ISO1_year + ISO2_year + ISOPAIR | 0 | ISOPAIR, dt_reg_tmp)
r3  <- felm(f5_d5_trade ~ d5_CUMECU + d5_FTA + d5_trade | ISO1_year + ISO2_year + ISOPAIR  | 0 | ISOPAIR, dt_reg_tmp)
r4  <- felm(f5_d5_trade ~ d5_CUMECU + d5_FTA + d5_trade | ISO1_year + ISO2_year + ISOPAIR  | 0 | ISOPAIR, dt_reg_tmp[peg2 == 0])
l_reg <- list(r1, r2, r3, r4)
screenreg(l_reg, include.fstatistic = T, stars = c(0.01, 0.05, 0.1))

# ------------------------------------------------------------------------------------------
# --------------
felm_to_DT <- function(riv, reg_names="r1s"){
  dt_iv <- data.table(reg_names = reg_names)
  dt_iv <- cbind(dt_iv, var_names=row.names(coefficients(summary(riv))))
  dt_iv <- cbind(dt_iv, data.table(coefficients(summary(riv))) )
  # Kleibergen-Paap Wald rk F statistic
  # dt_iv <- cbind(dt_iv, KP_Wald_F = summary(riv$stage1, lhs='d5_trade')$iv1fstat[["F"]])
  dt_iv <- cbind(dt_iv, R2 = summary(riv)$r2)
  dt_iv <- cbind(dt_iv, Nobs = summary(riv)$N)
  return(dt_iv)
}

# --------------
star_maker <- function(x){
  ifelse(x>0.1, "", ifelse(x>0.05, "$^{*}$", ifelse(x>0.01, "$^{**}$", "$^{***}$") ) )
}

reg_list <- list(quote(r1), quote(r2), quote(r3), quote(r4) )
dt_reg_trade <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist
dt_reg_trade[]

brew("./input/tables/table_1S_final.brew.tex", "./output/tables/tableA13.tex")
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# Second Stage
dt_reg <- dt_event_daily[ !is.na(ISOPAIR) & ISOPAIR != "" ]
dt_reg[, `:=`(ISO1 = base, ISO2 = foreign, datey = as.factor(year)) ]
dt_reg[, endog := f5_d5_trade]

dt_reg_tmp <- dt_reg[is.finite(endog) & is.finite(d5_trade) ]

r1  <- felm(f10_d5_fx_vol ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r2  <- felm(f10_d5_fx_vol ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r3  <- felm(f10_d5_fx_vol ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2==0])

r4  <- felm(f10_d5_vol_adj ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r5  <- felm(f10_d5_vol_adj ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r6  <- felm(f10_d5_vol_adj ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2==0])

r7  <- felm(f10_d5_R2_y ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r8  <- felm(f10_d5_R2_y ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r9  <- felm(f10_d5_R2_y ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2==0])

r10  <- felm(f10_d5_beta ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r11  <- felm(f10_d5_beta ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r12  <- felm(f10_d5_beta ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2==0])

l_reg0 <- list(r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12)
screenreg(l_reg0, include.fstatistic = T, stars = c(0.01, 0.05, 0.1), digits = 3)


dt_reg <- dt_event_daily[ !is.na(ISOPAIR) & ISOPAIR != "" ]
dt_reg[, `:=`(ISO1 = base, ISO2 = foreign, datey = as.factor(year)) ]
dt_reg[, endog := f5_d10_trade]

dt_reg_tmp <- dt_reg[is.finite(endog) & is.finite(d10_trade) ]

r13  <- felm(f15_d10_fx_vol ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r14  <- felm(f15_d10_fx_vol ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r15  <- felm(f15_d10_fx_vol ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r16  <- felm(f15_d10_vol_adj ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r17  <- felm(f15_d10_vol_adj ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r18  <- felm(f15_d10_vol_adj ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r19  <- felm(f15_d10_R2_y ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r20  <- felm(f15_d10_R2_y ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r21  <- felm(f15_d10_R2_y ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r22  <- felm(f15_d10_beta ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r23  <- felm(f15_d10_beta ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp)
r24  <- felm(f15_d10_beta ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ d5_CUMECU + d5_FTA) | ISOPAIR, dt_reg_tmp[peg2 == 0])

l_reg0 <- list(r13, r14, r15, r16, r17, r18, r19, r20, r21, r22, r23, r24)
screenreg(l_reg0, include.fstatistic = T, stars = c(0.01, 0.05, 0.1), digits = 3)

# ------------------------------------------------------------------------------------------

# --------------
felm_to_DT <- function(riv, reg_names="riv"){
  dt_iv <- data.table(reg_names = reg_names)
  dt_iv <- cbind(dt_iv, var_names=row.names(coefficients(summary(riv))))
  dt_iv <- cbind(dt_iv, data.table(coefficients(summary(riv))) )
  # Kleibergen-Paap Wald rk F statistic
  dt_iv <- cbind(dt_iv, KP_Wald_F = summary(riv$stage1, lhs='endog')$iv1fstat[["F"]])
  dt_iv <- cbind(dt_iv, R2 = summary(riv)$r2)
  dt_iv <- cbind(dt_iv, Nobs = summary(riv)$N)
  return(dt_iv)
}

felm_to_DT(r1)

# --------------
star_maker <- function(x){
  ifelse(x>0.1, "", ifelse(x>0.05, "$^{*}$", ifelse(x>0.01, "$^{**}$", "$^{***}$") ) )
}
# star_maker(0.1)
# ------------------------------------------------------------------------------------------


# WITH NSE
reg_list <- list(quote(r10), quote(r11), quote(r12), quote(r22), quote(r23), quote(r24)) 
dt_reg_beta <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

reg_list <- list(quote(r7), quote(r8), quote(r9), quote(r19), quote(r20), quote(r21)) 
dt_reg_R2 <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

# WITH NSE
reg_list <- list(quote(r1), quote(r2), quote(r3), quote(r13), quote(r14), quote(r15)) 
dt_reg_vol <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

reg_list <-  list(quote(r4), quote(r5), quote(r6), quote(r16), quote(r17), quote(r18))
dt_reg_adjvol <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

brew("./input/tables/table_2SLS_bilateral.brew.tex", "./output/tables/tableA15.tex")

# ------------------------------------------------------------------------------------------
# Endogenous Regressions

dt_reg <- dt_event_daily[ !is.na(ISOPAIR) & ISOPAIR != "" ]
dt_reg[, `:=`(ISO1 = base, ISO2 = foreign, datey = as.factor(year)) ]
dt_reg[, endog := f5_d5_trade]
dt_reg[, f10_d5_fx_vol := f10_d5_fx_vol*100]
dt_reg[, f10_d5_vol_adj := f10_d5_vol_adj*100]
dt_reg[, f10_d5_R2_y := f10_d5_R2_y*100]
dt_reg[, f10_d5_beta := f10_d5_beta*100]

dt_reg_tmp <- dt_reg[is.finite(endog) & is.finite(d5_trade) ]

r1  <- felm(f10_d5_fx_vol ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r2  <- felm(f10_d5_fx_vol ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r3  <- felm(f10_d5_fx_vol ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2==0])

r4  <- felm(f10_d5_vol_adj ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ endog) |  ISOPAIR, dt_reg_tmp)
r5  <- felm(f10_d5_vol_adj ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r6  <- felm(f10_d5_vol_adj ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2==0])

r7  <- felm(f10_d5_R2_y ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r8  <- felm(f10_d5_R2_y ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) |  ISOPAIR, dt_reg_tmp)
r9  <- felm(f10_d5_R2_y ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2==0])

r10  <- felm(f10_d5_beta ~ d5_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year| (endog ~ endog) |  ISOPAIR, dt_reg_tmp)
r11  <- felm(f10_d5_beta ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r12  <- felm(f10_d5_beta ~ d5_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2==0])

l_reg0 <- list(r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12)
screenreg(l_reg0, include.fstatistic = T, stars = c(0.01, 0.05, 0.1), digits = 3)


dt_reg <- dt_event_daily[ !is.na(ISOPAIR) & ISOPAIR != "" ]
dt_reg[, `:=`(ISO1 = base, ISO2 = foreign, datey = as.factor(year)) ]
dt_reg[, endog := f5_d10_trade]
dt_reg[, f15_d10_fx_vol := f15_d10_fx_vol*100]
dt_reg[, f15_d10_vol_adj := f15_d10_vol_adj*100]
dt_reg[, f15_d10_R2_y := f15_d10_R2_y*100]
dt_reg[, f15_d10_beta := f15_d10_beta*100]

dt_reg_tmp <- dt_reg[is.finite(endog) & is.finite(d10_trade) ]

r13  <- felm(f15_d10_fx_vol ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ endog) |  ISOPAIR, dt_reg_tmp)
r14  <- felm(f15_d10_fx_vol ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r15  <- felm(f15_d10_fx_vol ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r16  <- felm(f15_d10_vol_adj ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ endog) |  ISOPAIR, dt_reg_tmp)
r17  <- felm(f15_d10_vol_adj ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r18  <- felm(f15_d10_vol_adj ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r19  <- felm(f15_d10_R2_y ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r20  <- felm(f15_d10_R2_y ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r21  <- felm(f15_d10_R2_y ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2 == 0])

r22  <- felm(f15_d10_beta ~ d10_trade + log(distw) + contig + comlang_off + comcol + comleg_pretrans | ISO1_year + ISO2_year | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r23  <- felm(f15_d10_beta ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp)
r24  <- felm(f15_d10_beta ~ d10_trade | ISO1_year + ISO2_year + ISOPAIR | (endog ~ endog) | ISOPAIR, dt_reg_tmp[peg2 == 0])

l_reg0 <- list(r13, r14, r15, r16, r17, r18, r19, r20, r21, r22, r23, r24)
screenreg(l_reg0, include.fstatistic = T, stars = c(0.01, 0.05, 0.1), digits = 3)

# ------------------------------------------------------------------------------------------

# --------------
felm_to_DT <- function(riv, reg_names="riv"){
  dt_iv <- data.table(reg_names = reg_names)
  dt_iv <- cbind(dt_iv, var_names=row.names(coefficients(summary(riv))))
  dt_iv <- cbind(dt_iv, data.table(coefficients(summary(riv))) )
  # Kleibergen-Paap Wald rk F statistic
  dt_iv <- cbind(dt_iv, KP_Wald_F = summary(riv$stage1, lhs='endog')$iv1fstat[["F"]])
  dt_iv <- cbind(dt_iv, R2 = summary(riv)$r2)
  dt_iv <- cbind(dt_iv, Nobs = summary(riv)$N)
  return(dt_iv)
}

felm_to_DT(r1)

# --------------
star_maker <- function(x){
  ifelse(x>0.1, "", ifelse(x>0.05, "$^{*}$", ifelse(x>0.01, "$^{**}$", "$^{***}$") ) )
}

# WITH NSE
reg_list <- list(quote(r10), quote(r11), quote(r12), quote(r22), quote(r23), quote(r24)) 
dt_reg_beta <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

reg_list <- list(quote(r7), quote(r8), quote(r9), quote(r19), quote(r20), quote(r21)) 
dt_reg_R2 <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist


# WITH NSE
reg_list <- list(quote(r1), quote(r2), quote(r3), quote(r13), quote(r14), quote(r15)) 
dt_reg_vol <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist

reg_list <-  list(quote(r4), quote(r5), quote(r6), quote(r16), quote(r17), quote(r18))
dt_reg_adjvol <- reg_list %>% purrr::map(function(x) {y <- felm_to_DT(eval(x), reg_names=as.character(x))}) %>% rbindlist




